<?php
/*--------------------------------------------------------------
   Table.php 2021-08-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

use Gambio\Admin\Modules\Statistics\Model\Collections\TableColumns;
use Gambio\Admin\Modules\Statistics\Model\Collections\TableRows;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data;

class Table implements Data
{
    /**
     * @var TableRows
     */
    private $rows;
    
    /**
     * @var TableColumns
     */
    private $columns;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(TableColumns $columns, TableRows $rows)
    {
        $this->rows    = $rows;
        $this->columns = $columns;
        $this->type    = 'table';
    }
    
    
    /**
     * Create instance.
     */
    public static function create(TableColumns $columns, TableRows $rows): self
    {
        return new self($columns, $rows);
    }
    
    
    /**
     * Return rows.
     */
    public function rows(): TableRows
    {
        return $this->rows;
    }
    
    
    /**
     * Return columns.
     */
    public function columns(): TableColumns
    {
        return $this->columns;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
}